<?php
require_once ('../database/dbhelper.php');
?>
<!DOCTYPE html>
<html lang='en'>
<head>
	<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Danh Sách Đơn Hàng</title>
	<!-- Font Awesome-->
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

	<!-- Latest compiled and minified CSS -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">

	<!-- jQuery library -->
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

	<!-- Popper JS -->
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>

	<!-- Latest compiled JavaScript -->
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
    <!-- PHẦN CSS-->
	<style>
		.panel-heading h2 {
			color:#0d1955; 
			font-size: 4em; 
			margin-top: 100px;
			text-align:center;
			margin-bottom: 100px;
  			font-weight: bold;
  			font-family: Helvetica;
		}
		/* Tiêu đề h1 */
		.hit-the-floor {
			text-align: center;
			color: #0d1955;
			font-size: 4em;
			margin-bottom: 30px;
			font-weight: bold;
			font-family: Helvetica;
			text-align: center;
		}
		/* Phần header */
		header {
			z-index: 1;
			position: fixed;
			background: #043283c5;
			padding-left: 20px;
			width: calc(100% - 0%);
			top: 0;
			height: 65px;
		}
		.left-area h3 {
			color: #fff;
			margin: 0;
			text-transform: uppercase;
			font-size: 22px;
			font-weight: 900;
		}
		.left-area span {
			color: #1dc4e7;
		}
		.logout_btn {
			padding: 5px;
			background: #19b3d3;
			text-decoration: none;
			float: right;
			margin-top: -30px;
			margin-right: 40px;
			border-radius: 2px;
			font-size: 15px;
			font-weight: 600;
			color: #fff;
			transition: 0.5s;
		}
		.logout_btn:hover {
			padding: 5px;
			text-decoration: none;
			float: right;
			margin-top: -30px;
			margin-right: 40px;
			border-radius: 2px;
			font-size: 15px;
			font-weight: 600;
			color: #fff;
			background: #0d9dbb;
		}
		/* Phần sidebar */
		.sidebar {
			z-index: 1;
			top: 0;
			background: #19499ac5;
			margin-top: 65px;
			padding-top: 30px;
			position: fixed;
			left: 0;
			width: 255px;
			height: 100vh;
			transition: 0.5s;
			transition-property: left;
			overflow-y: auto;
			overflow-x: hidden;
		}
		.sidebar .profile_info .profile_image {
			width: 100px;
			height: 100px;
			border-radius: 100px;
			margin-bottom: 10px;
		}
		.sidebar .profile_info h4 {
			color: #ccc;
			margin-top: 0;
			margin-bottom: 20px;
		}
		.sidebar a {
			color: #fff;
			display: block;
			width: 100%;
			line-height: 70px;
			text-decoration: none;
			padding-left: 50px;
			box-sizing: border-box;
			transition: 0.5s;
		}
		.sidebar a:hover {
			color: #fff;
			display: block;
			width: 100%;
			line-height: 60px;
			text-decoration: none;
			padding-right: 15px;
			box-sizing: border-box;
			background: #19b3d3;
		}
		.sidebar i {
			padding-right: 10px;
		}
		label #sidebar_btn {
			z-index: 1;
			color: #fff;
			position: fixed;
			cursor: pointer;
			left: 300px;
			top: 18px;
			font-size: 20px;
			margin: 5px 0;
			transition: 0.5s;
			transition-property: color;
		}
		label #sidebar_btn:hover {
			color: #19b3d3;
		}
		#check:checked ~ .sidebar {
			left: -185px;
		}
		#check:checked ~ .sidebar a span {
			display: none;
		}
		#check:checked ~ .sidebar a {
			font-size: 20px;
			margin-left: 150px;
			width: 100%;
		}
		/* Phần nội dung chính */
		.content {
			width: calc(100% - 250px);
			margin-top: 60px;
			padding: 20px;
			margin-left: 250px;
			padding-top: 65px;
			background-color: #fff;
			background-position: center;
			background-size: cover;
			transition: 0.5s;
		}
		#check:checked ~ .content {
			width: calc(100% - 60px);
			margin-left: 60px;
		}
		#check:checked ~ .sidebar .profile_info {
			display: none;
		}
		#check {
			display: none;
		}
		.mobile_nav {
			display: none;
		}
		/* Responsive css */
		@media screen and (max-width: 780px) {
		/* Phần header */
		.left-area h3 {
			color: #fff;
			margin: 0;
			text-transform: uppercase;
			font-size: 17px;
			font-weight: 550;
		}
		.logout_btn {
			padding: 5px;
			background: #19b3d3;
			text-decoration: none;
			float: right;
			margin-top: -30px;
			margin-right: 40px;
			border-radius: 2px;
			font-size: 13px;
			font-weight: 500;
			color: #fff;
			transition: 0.5s;
		}
		.logout_btn:hover {
			padding: 5px;
			text-decoration: none;
			float: right;
			margin-top: -30px;
			margin-right: 40px;
			border-radius: 2px;
			font-size: 13px;
			font-weight: 500;
			color: #fff;
			background: #0d9dbb;
		}
		/* Phần sidebar */
		.sidebar {
			display: none;
		}
		#sidebar_btn {
			display: none;
		}
		/* Phần nội dung chính */
		.content {
			width: calc(100% - 255px); /* Điều chỉnh chiều rộng của nội dung chính */
			margin-top: 65px; /* Điều chỉnh margin-top để không bị che bởi phần sidebar */
			padding: 20px;
			margin-left: 255px;
			padding-top: 65px;
			background-color: #fff;
			background-position: center;
			background-size: cover;
			transition: 0.5s;
			float: right; /* Di chuyển sang bên phải */
		}

		#check:checked ~ .content {
			width: calc(100% + 0px);
			margin-left: 0;
		}
		/* Phần sidebar responsive thành nav*/
		.mobile_nav {
			display: block;
			width: calc(100% + 0px);
		}
		
		.mobile_profile_image {
			width: 50px;
			height: 50px;
			border-radius: 50%;
		}
		.nav_btn {
			color: #fff;
			font-size: 22px;
			cursor: pointer;
			transition: 0.5s;
			transition-property: color;
		}
		.nav_btn:hover {
			color: #19b3d3;
		}
		.mobile_nav_items {
			background: #2f323a;
			display: none;
		}
		.mobile_nav_items a {
			color: #fff;
			display: block;
			text-align: center;
			letter-spacing: 1px;
			line-height: 60px;
			text-decoration: none;
			box-sizing: border-box;
			transition: 0.5s;
		}
		.mobile_nav_items a:hover {
			color: #fff;
			display: block;
			text-align: center;
			letter-spacing: 1px;
			line-height: 60px;
			text-decoration: none;
			box-sizing: border-box;
			background: #19b3d3;
		}
		.mobile_nav_items i {
			padding-right: 10px;
		}
		.active {
			display: block;
		}
		}
		.panel-body {
			margin-top: 100px; /* Điều chỉnh margin-top cho phần panel-body */	
			margin-left: 150px; /* Đẩy phần bảng sang phải */
   	 		margin-right: -150px;					
 
		}
		.panel-body h2 {
			margin-top: 0; /* Đặt margin-top của tiêu đề "Danh sách đơn hàng" về 0 */
			font-size: 4em; /* Đặt kích thước font cho tiêu đề "Danh sách đơn hàng" */
			color:#0d1955
		}
  	</style>	
    <!--CSS END-->
</head>
<body>
	<input type="checkbox" id="check" />
    <!-- PHẦN HEADER START -->
    <header>
      <label for="check"><i class="fas fa-bars" id="sidebar_btn"></i></label>
      <div class="left-area">
        <h3>Admin <span>Management</span></h3>
      </div>
      <div class="right-area">
        <form action="/BTLWEB/authen/logout.php" method="post"> 
          <button type="submit" name="logout" value="Logout" class="logout_btn">Đăng xuất</button>
        </form> 
      </div>
    </header>
	<!-- PHẦN HEADER END -->

	<!-- PHẦN SIDEBAR RESPONSIVE START -->
    <div class="mobile_nav">
  		<div class="mobile_nav_items">
		  	<a href="/BTLWEB/view/index.php"><i class="fas fa-home"></i><span> Trang chủ</span></a>
			<a href="/BTLWEB/category/list_category.php"><i class="fas fa-cogs"></i><span> Danh mục sản phẩm</span></a>
			<a href="/BTLWEB/user/list_user.php"><i class="fas fa-users"></i><span> Quản lí người dùng</span></a>
			<a href="/BTLWEB/product/list_product.php"><i class="fas fa-shopping-cart"></i><span> Quản lí sản phẩm</span></a>
			<a href="/BTLWEB/order/list_order.php"><i class="fas fa-box-open"></i><span> Quản lí đơn hàng</span></a>
			<a href="/BTLWEB/feedback/list_feedback.php"><i class="fas fa-desktop"></i><span> Phản hồi của khách</span></a>
  		</div>
	</div>
    <!-- PHẦN SIDEBAR RESPONSIVE END -->
	<!-- PHẦN SIDEBAR START -->
    <div class="sidebar">
		<a href="/BTLWEB/view/index.php"><i class="fas fa-home"></i><span> Trang chủ</span></a>
		<a href="/BTLWEB/category/list_category.php"><i class="fas fa-cogs"></i><span> Danh mục sản phẩm</span></a>
		<a href="/BTLWEB/user/list_user.php"><i class="fas fa-users"></i><span> Quản lí người dùng</span></a>
		<a href="/BTLWEB/product/list_product.php"><i class="fas fa-shopping-cart"></i><span> Quản lí sản phẩm</span></a>
		<a href="/BTLWEB/order/list_order.php"><i class="fas fa-box-open"></i><span> Quản lí đơn hàng</span></a>
		<a href="/BTLWEB/feedback/list_feedback.php"><i class="fas fa-desktop"></i><span> Phản hồi của khách</span></a>
    </div>
    <!-- PHẦN SIDEBAR END -->

    
	<!--PHẦN DANH SÁCH ĐƠN HÀNG-->
	<div class="container">
		<div class="panel panel-primary">
			<div class="panel-body" style="position: relative; left:15%;">
				<h2 class="text-center"> Danh sách đơn hàng </h2>
			</div>	
			<div class="panel-body">
				<a href="add.php">
					<button class="btn btn-success" style="margin-bottom: 15px;">Thêm Đơn Hàng</button>
				</a>
				<table class="table table-bordered table-hover">
					<thead>
						<tr>
							<th width="50px">STT</th>
							<th width="50px">ID</th>
							<th width="300px">HỌ VÀ TÊN</th>
							<th width="250px">EMAIL</th>
							<th width="80px">SỐ ĐIỆN THOẠI</th>
							<th width="350px">ĐỊA CHỈ</th>
							<th width="300px">GHI CHÚ</th>
							<th width="100px">NGÀY ĐẶT</th>
							<th width="50px">TRẠNG THÁI</th>
							<th width="50px">TỔNG TIỀN</th> 
							<th width="50px"></th> 
							<th width="50px"></th>                       
						</tr>
					</thead> 		
					<?php
	//Lấy danh sách đơn hàng từ cơ sở dữ liệu
	$sql = 'SELECT * FROM orders';
	$ordersList = executeResult($sql);
	$index = 0;
	foreach ($ordersList as $item) {
		echo '<tr>
				<td>'.(++$index).'</td>
				<td>' . $item['id'] . '</td>
				<td>' . $item['fullname'] . '</td>
				<td>' . $item['email'] . '</td>
				<td>' . $item['phone_number'] . '</td>
				<td>' . $item['address'] . '</td>
				<td>' . $item['note'] . '</td>
				<td>' . $item['order_date'] . '</td>
				<td>' . $item['status'] . '</td>
				<td>' . $item['total_money'] . '</td>
				<td>
					<a href="add.php?id='.$item['id'].'"><button class="btn btn-warning">Sửa</button></a>
				</td>
				<td>
					<button class="btn btn-danger" onclick="deleteOrders(' . $item['id'] . ')">Xoá</button>
				</td>
			</tr>';
	}
	?>
				</table>
			</div>
		</div>
	</div>

<script type="text/javascript">
    function deleteOrders(id) {
        var option = confirm('Bạn có chắc chắn muốn xoá đơn hàng này không?')
        if (!option) {
            return;
        }

        console.log(id)
        //ajax - lenh post
        $.post('ajax.php', {
            'id': id,
            'action': 'delete'
        }, function(data) {
            location.reload()
        })
    }
	
</script>
</body>
</html>